# ChargingProblem JSON File Format

This document describes the structure and meaning of a serialized
`ChargingProblem` instance stored as a JSON file.

The file fully defines an electric vehicle (EV) and stationary battery
charging scheduling problem over a finite time horizon.  
It contains **only data**, no solver configuration or results.

---

## File Structure Overview

The JSON file is a single object with the following top-level sections:

- **Global problem parameters**
- **EV-related parameters**
- **Grid and load parameters**
- **Stationary battery parameters**
- **Renewable generation**
- **Optimization configuration**

Each field corresponds directly to an attribute of the
`ChargingProblem` class.

---

## Global Problem Parameters

### `num_evs` (int)
Number of electric vehicles considered in the problem.

---

### `horizon` (int)
Number of discrete time intervals in the scheduling horizon.

---

### `interval_length` (float)
Length of a regular time interval.

---

### `first_interval_length` (float)
Length of the first interval.
This allows modeling a shorter initial interval when aligning to
real-world clock times.

---

### `fraction_last_interval` (float or array)
Fraction of the last interval used for SOC integration.
Useful when the final interval is truncated.

---

### `min_e_grid` (float)
Minimum grid energy value.
Typically used as:
- a lower bound in the objective, or
- a normalization/reference value in hierarchical optimization.

---

## Electric Vehicle (EV) Parameters

All EV-related arrays are indexed by EV ID  
(`0 … num_evs-1`).

---

### `min_socs` (array)
Minimum allowed state-of-charge (SOC) for each EV.

---

### `max_socs` (array)
Maximum allowed SOC for each EV.

---

### `init_socs` (array)
Initial SOC of each EV at the start of the horizon.

---

### `target_socs` (array)
Desired target SOC for each EV at the end of its availability window.

---

### `ev_min_final_socs` (array)
Minimum required SOC at the final time step for each EV.
This may differ from `target_socs`.

---

### `ev_capacities` (array)
Battery capacity of each EV (e.g. in kWh).

---

### `vip_status` (array of bool)
VIP flags for EVs.
VIP vehicles may receive priority in:

---

### `ev_end_intervals` (array)
Last time interval index in which each EV is available for charging.
After this index, the EV is assumed to be disconnected.

---

### `ev_p_max` (array)
Maximum charging power for each EV.

---

### `ev_p_min` (array)
Minimum charging power for each EV.
This may be zero or negative.

---

## Grid and Load Constraints

### `load_limits` (array)
Maximum allowable total grid load per time interval.

---

## Stationary Battery Parameters

All stationary battery arrays are indexed by battery ID  
(`0 … num_bat-1`).

---

### `num_bat` (int)
Number of stationary batteries in the system.

---

### `bat_capacities` (array)
Energy capacity of each stationary battery.

---

### `bat_socs` (array)
Initial SOC of each stationary battery.

---

### `bat_target_socs` (array)
Target SOC for stationary batteries at the end of the horizon.

---

### `bat_p_max` (array)
Maximum charging power for each stationary battery.

---

### `bat_p_min` (array)
Minimum charging power for each stationary battery
(negative values allow discharging).

---

## Renewable Generation

### `p_pv` (array)
Photovoltaic (PV) power production available at each time interval.

---

## Optimization Configuration

### `objective_hierarchy` (sequence)
Defines the hierarchical optimization structure.

---

### `hierachical` (bool)
If `true`, objectives are optimized hierarchically (lexicographically).

---

### `soft_limits` (bool or structure)
Deprecated

---

